 ; Filthy - find and mark all occurrences of any entity type.
 ; Copyright 1995, 2004, 2006 by Rocket Software Ltd.
 ; Dedicated to Henry Kuttner for "The Misguided Halo."
 (DEFUN C:FILTHY ( / num bl blt ss rad len so txa pa nnum)
  (setvar "cmdecho" 0)
  (setq blt (getstring "Entity type to mark or <Return> for everything: "))
  (if (= blt "")
      (setq ss (ssget "X" (list (cons 410 (getvar "ctab")))))
      (progn
           (setq bl (cons 0 blt))
           (setq ss (ssget "X" (list bl (cons 410 (getvar "ctab")))))))
  (if ss
     (progn
          (if (not (setq rad (getdist (getvar "viewctr")
                                     "Marker length (<Return> for preset): ")))
              (setq rad (/ (getvar "viewsize") 25)))
          (setq len (strcat "/" (itoa (sslength ss))))
          (setq num 0)
          (setq nnum 0)
          (while (setq so (ssname ss num))
                 (setq txa (entget so))
                 (setq num (1+ num))
                 (grtext -2 (strcat (itoa num) len))
                 (if (= (cdr (assoc 0 txa)) "POLYLINE")
                     (setq pa (cdr (assoc 10 (entget (entnext so)))))
                     (setq pa (cdr (assoc 10 txa))))
                 (if pa
                     (progn
                          (grdraw (polar pa (/ pi 4) rad)
                                  (polar pa (* 1.25 pi) rad) 7)
                          (grdraw (polar pa (* pi 0.75) rad)
                                  (polar pa (* pi 1.75) rad) 7))
                     (setq nnum (1+ nnum))))
          (write-line (strcat "\nEntities found: " (itoa num)))
          (if (< 0 nnum)
              (write-line (strcat "\nEntities with no insertion point: "
                                  (itoa nnum)))))
    (if (= bl "")
        (write-line "\nApparently this drawing is completely empty. ")
        (write-line "\nCan't find any such thing.")))
 (princ))